// Force a processor reset, to allow a new program to be bootloaded.
// Units:      watchdog timer
// Interrupts: system reset
// Pins:       none
// Clock:      any
//
static void
reset_processor()
   {
   WDTCSR |= (1 << WDCE) | (1 << WDE);
   WDTCSR  = 0
             | (0 << WDCE)
             | (1 << WDE)  // use "reset mode" not "interrupt mode"

             | (0 << WDP0) // fire reset after 1 second
             | (1 << WDP1)
             | (1 << WDP2)
             | (0 << WDP3)
             ;
   
   for (;;); // wait for reset
   }
