// Atmega startup.
// Units:      CLOCK
// Interrupts: enabled
// Pins:       none
// Clock:      8/16Mhz
//
static void
SYSTEM_init()
   {
#if CLOCK_MHZ == 8
   #if CLOCK_INTERNAL
   // lfuse=0xe2: 8Mhz internal oscillator with no clock prescaler
   ;
   #else
   // lfuse=0x7f: 16Mhz crystal oscillator with clock prescaler
   // initially set to "divide by 8", yielding a 2Mhz system clock.
   // reconfigure the prescaler to yield an 8Mhz system clock.
   //
   CLKPR = (1 << CLKPCE); // toggle clock prescaler change enable...
   CLKPR = (0 << CLKPCE)  // ...and         [ see p. 37
         | (0 << CLKPS3)  // ...set              of datasheet ]
         | (0 << CLKPS2)  // ...new
         | (0 << CLKPS1)  // ...clock prescaler
         | (1 << CLKPS0)  // ...to "divide by 2"
         ;
   #endif
#elif CLOCK_MHZ == 16
   // lfuse=0xe6: 16Mhz crystal oscillator with no clock prescaler
   ;
#else
   #error clock!
#endif

   // Turn off watchdog timer in case it was the source of this system reset.
   // Ref: section 10.8.1 of datasheet.
   //
   asm volatile ("wdr");  // reset watchdog timer

   MCUSR  &= ~(1<<WDRF);  // clear reset condition so it won't generate an interrupt
   
   WDTCSR |=  (1<<WDCE) | (1<<WDE);  // turn off...
   WDTCSR  =  0;                     // ...watchdog timer

   // Run with interrupts enabled.
   // Ref: initialization routine on p.64 of datasheet.
   //
   sei();
   }
