// Camera control.
//

#define CAM_BIAS   Config.cam_bias
#define CAM_L_GAIN Config.cam_l_gain
#define CAM_R_GAIN Config.cam_r_gain

//------------------------------
// Interrupt communication area.
//
static volatile BOOL CAM_enabled; // rotate camera to follow imu horizon
static volatile WORD CAM_hits;
//
//------------------------------

// Rotate camera to specified angle, in radians.
//
void
CAM_set(FLOAT angle)
   {
   CAM_hits += 1;
   
   angle = -angle; // camera polarity with respect to servo and imu sign conventions
   angle = DEG(angle);
   angle += CAM_BIAS;

   if (angle > 0) SERVO_set((SERVO_TENTHS)(angle * CAM_L_GAIN));
   else           SERVO_set((SERVO_TENTHS)(angle * CAM_R_GAIN));
   }

// Rotate camera to follow imu horizon.
// Called by interrupt.
//
static void
CAM_update()
   {
   if (CAM_enabled)
      CAM_set(IMU_getRollAngle());
   }
