// Error handlers.
//

// --------------------------------------------------------------------
//                        Implementation.
// --------------------------------------------------------------------

typedef enum {
             ERR_BATTERY = 2,
             ERR_POWER   = 3,
             ERR_TIMEOUT = 4,
             ERR_TWI     = 5,
             } ERR;

// Handle an error: stop background thread (and timebase), stop watchdog, move camera to failsafe position, display a message, blink a code.
// Taken:    code number
//           message
// Returned: never returns
//
void
ERR_blink(ERR code, const char *str)
   {
   // quiesce
   //
   DI();
   WATCHDOG_stop();
   CAM_set(0);
   
   BYTE cycles = 0;
   for (;;)
      {
      // display message
      //
      printf("%s!\n", str);
      LCD_init(); LCD_printf(0, ("Error: %s", str));

      // blink code
      //
      BYTE i;
      for (i = 0; i < code; ++i)
         {
         LED_on();  delay_ms(200);
         LED_off(); delay_ms(400);
         }
      delay_ms(800);
      
      // if battery runs down, turn off power after 10 blink cycles to prevent over-discharge
      //
      if (BAT_read() <= BATTERY_LOW && ++cycles >= 10)
         {
         printf("shutdown!\n");
         PWR_off();
         }
      }
   
   EI();
   }

// --------------------------------------------------------------------
//                          Interface.
// --------------------------------------------------------------------

// Report a low battery condition.
//
void
ERR_battery()
   {
   ERR_blink(ERR_BATTERY, "battery");
   }

// Report a power supply problem (we just emerged from a brownout reset).
//
void
ERR_power()
   {
   ERR_blink(ERR_POWER, "power");
   }

// Report a watchdog timeout (some operation did not complete within assigned time limit - perhaps sensor not present or not responding due to noise).
//
void
ERR_timeout()
   {
   ERR_blink(ERR_TIMEOUT, "timeout");
   }

// Report a TWI communication error (perhaps sensor not present or not responding due to noise).
//
void 
ERR_twi()
   {
   ERR_blink(ERR_TWI, "twi");
   }
