// Atmega startup.
// Units:      CLOCK, WATCHDOG
// Interrupts: enabled
// Pins:       none
// Clock:      8/16Mhz
//
static void
SYSTEM_init()
   {
#if CLOCK_MHZ == 8
   #if CLOCK_INTERNAL
   // LFUSE=0xE2: 8Mhz internal oscillator with no clock prescaler
   ;
   #else
   // LFUSE=0x7F: 16Mhz crystal oscillator with clock prescaler,
   // initially set to "divide by 8", yielding a 2Mhz system clock.
   // We reconfigure the prescaler to yield an 8Mhz system clock.
   //
   CLKPR = (1 << CLKPCE); // toggle clock prescaler change enable...
   CLKPR = (0 << CLKPCE)  // ...and         [ see p. 37
         | (0 << CLKPS3)  // ...set              of datasheet ]
         | (0 << CLKPS2)  // ...new
         | (0 << CLKPS1)  // ...clock prescaler
         | (1 << CLKPS0)  // ...to "divide by 2"
         ;
   #endif
#elif CLOCK_MHZ == 16
   // LFUSE=0xE6: 16Mhz crystal oscillator with no clock prescaler
   ;
#else
   #error CLOCK_MHZ
#endif

   // Turn off watchdog timer in case it was the source of this system reset.
   // Ref: section 10.8.1 of datasheet.
   //
   asm volatile ("wdr");                // restart timer so we can issue the next few instructions before watchdog fires again
   MCUSR  &= ~(1 << WDRF);              // clear flag so watchdog won't fire again when we issue sei()
   WDTCSR |=  (1 << WDCE) | (1 << WDE); // disable...
   WDTCSR  =  0;                        // ...watchdog

   // Run with interrupts enabled.
   // Ref: initialization routine on p.64 of datasheet.
   //
   sei();
   }
