#if HAVE_LCD_DISPLAY

// Digole Electronics 1602 LCD display.
//

#define LCD_COLS 16
#define LCD_ROWS  2

// Turn cursor on(1) or off (0).
//
static void
LCD_cursor(BOOL val)
   {
   putchar('C'), putchar('S'), putchar(val);
   }

// Clear display and position cursor at 0,0.
//
static void
LCD_clear()
   {
   putchar('C'), putchar('L'), putchar(0);
   }

// Prepare display for use.
// Note: after powerup the LCD processor takes 1-2 seconds to boot, so these commands might not have any effect until then.
//
static void
LCD_init()
   {
   LCD_cursor(0); // cursor off
   LCD_clear();   // clear screen
   }

// Begin text string at specified row(0..1) and column(0..15).
// Note: terminate string with \n, \r, or \0 (none of which have any effect on cursor position).
//
static void
LCD_text(BYTE row, BYTE col)
   {
   putchar('T'), putchar('P'), putchar(col), putchar(row);
   putchar('T'), putchar('T');
   }

// End text string.
//
static void
LCD_end()
   {
   putchar('\r');
   }

// Printf to specified row (0..1).
//
#define LCD_printf(R, X) LCD_text(R, 0), printf X, LCD_end()

// Special characters.
//
#define LCD_BOX 255

// Print a box character.
//
static void
LCD_box()
   {
   putchar(LCD_BOX);
   }

// Print a centered horizontal bar whose +/- length is proportional to a value.
// Taken: value, currently
//        value, corresponding to full swing
//
void
LCD_bar(FLOAT value, FLOAT range)
   {
   BYTE i, N = LCD_COLS;
   BYTE cells[N];
   
   // clear
   for (i = 0; i < N; ++i)
      cells[i] = ' ';
   
   FLOAT vn = value / range;  // normalized value
   if (vn < -1) vn = -1;
   if (vn > +1) vn = +1;
   
   BYTE c = N / 2;            // center cell
   BYTE v = (1 + vn) / 2 * N; // cell corresponding to normalized value
   
   // fill from center to right
   for (i = c; i < v; ++i)     
      cells[i] = LCD_BOX;
   
   // fill from left to center
   for (i = v; i < c; ++i)     
      cells[i] = LCD_BOX;

   // overlay center with 2 digit number
   FLOAT n = fabs(value);
   if (n < 100)
      {
      char str[3];
      snprintf(str, sizeof(str), "%2.0f", fabs(n));
      cells[c - 1] = str[0];
      cells[c]     = str[1];
      }

   // print
   LCD_text(1, 0);
   for (i = 0; i < N; ++i)
      putchar(cells[i]);
   LCD_end();
   }

#else

#define LCD_COLS  0
#define LCD_ROWS  0
#define LCD_init()
#define LCD_clear()
#define LCD_text(R, C)
#define LCD_box()
#define LCD_end()
#define LCD_printf(R, X)
#define LCD_bar(V, R)

#endif
