// Timing functions.
// These rely on timer interrupt to generate timebase.
//

extern volatile TICKS Ticks; // current time, updated at a rate of TICKER_HZ

// Get current time.
//
TICKS
TIME_now()
   {
   DI();
   TICKS t = Ticks;
   EI();
   return t;
   }

// How much time has elapsed since "start", in seconds?
//
static inline FLOAT
TIME_elapsed(TICKS *start)
   {
   return (TIME_now() - *start) * (1.0 / TICKER_HZ);
   }

// Pause a moment.
//
void
TIME_pause(FLOAT seconds)
   {
   TICKS start = TIME_now();
   while (TIME_elapsed(&start) < seconds) ;
   }

// Check if it's time to perform some periodic action.
// Taken:    place to keep timebase, initialized with starting time
//           time interval to wait between actions
// Returned: perform action now?
//
BOOL
TIME_periodic(TICKS *timebase, FLOAT seconds)
   {
   if (TIME_elapsed(timebase) < seconds)
      return 0;
   *timebase = TIME_now();
   return 1;
   }
