// Time base generator and scheduler.
//
// Units:      TIMER0
// Interrupts: TIMER0

// --------------------------------------------------------------------
//                        Implementation.
// --------------------------------------------------------------------

//------------------------------
// Interrupt communication area.
//
volatile TICKS Ticks; // current time, updated at TICKER_HZ
//
//------------------------------

// Handle timer tick interrupt.
//
static void
TICKER_interrupt()
   {
   // set a timeout so we don't wait forever on a sensor that's not present or not responding
   WATCHDOG_restart();
   
   // note: verify proper "hit" rates using '?' command in adjust_imu()
   Ticks += 1;

 //return; // uncomment this when running timing_tests()

   // schedule and dispatch events
                                      // 400Hz ticker
                       GYRO_update(); // 400/1=400Hz = GYRO_HZ x 2 (actual gyro data rate ~190-210Hz)
   if (Ticks % 4 == 0) ACC_update();  // 400/4=100Hz = ACC_HZ  x 2 (actual acco data rate      ~50Hz)
   if (Ticks % 2 == 0) IMU_update();  // 400/2=200Hz = IMU_HZ
   if (Ticks % 2 == 0) CAM_update();  // 400/2=200Hz = CAM_HZ
   }

// --------------------------------------------------------------------
//                        Interface.
// --------------------------------------------------------------------

// Enable periodic interrupts for time base, sensor updates, and integrator.
//
static void
TIMEBASE_init()
   {
   TICKER_init(TICKER_interrupt);
   }
