// Watchdog timer.
//
// Units:      WDT
// Interrupts: none
// Pins:       none
// Clock:      any
//

// --------------------------------------------------------------------
//                          Interface.
// --------------------------------------------------------------------

#define WATCHDOG_TIMEOUT 1 // fire reset after 1 second
   
// Set watchdog timer to force a processor reset after WATCHDOG_TIMEOUT seconds.
//
static void
WATCHDOG_start()
   {
   DI();
   
   asm volatile ("wdr");
   WDTCSR |= (1 << WDCE) | (1 << WDE);
   WDTCSR  = 0
             | (0 << WDCE)
             | (1 << WDE)  // use "reset mode" not "interrupt mode"

             | (0 << WDP0) // fire reset after 1 second
             | (1 << WDP1)
             | (1 << WDP2)
             | (0 << WDP3)
             ;
   EI();
   }

// Give ourself another WATCHDOG_TIMEOUT seconds before the watchdog timer fires.
//
static void
WATCHDOG_restart()
   {
   asm volatile ("wdr");
   }

// Turn off watchdog timer.
//
static void
WATCHDOG_stop()
   {
   DI();
   asm volatile ("wdr");
   WDTCSR |=  (1 << WDCE) | (1 << WDE);
   WDTCSR  = 0x00;
   EI();
   }
